/** @file   particle.cpp
 * @brief   Implementation of Particle - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#include "particle.h"

namespace eng2d {

///
/// Static members, constants and datatypes
/// =======================================




///
/// Constructors, destructor and operators
/// ======================================
/** Constructor
 */
Particle::Particle() :
  Interactive(),
  m_timeleft( 0 ),
  m_maxlife( 1 ),
  m_size( 2 ),
  m_friction( 1 )
{
}



/** Destructor
 */
Particle::~Particle()
{
}




///
/// Public methods
/// ==============

/** Updates this particle
 */
void Particle::update()
{
  if ( m_timeleft < 0 ) {
    m_dead = true;
    return;
  }

  m_timeleft -= 1;
  m_pos += m_dirVec;
  m_dirVec *= m_friction;
  m_dead = false;
}



/** Redraws this particle.
 */
void Particle::redraw( BITMAP* pB, const Vec2D& offset ) const
{
  if ( m_timeleft < 0 ) {
     return;
  }

  if ( m_size == 1 ) {
    Color c;
    m_grad.color( m_timeleft, 0, m_maxlife, &c );
    
    putpixel( pB, static_cast<int>( m_pos.vx - offset.vx ),
                  static_cast<int>( m_pos.vy - offset.vy ),
                  c.allC() );

  } else if ( m_size == 2 ) {
    Color c;
    m_grad.color( m_timeleft, 0, m_maxlife, &c );
    
    hline( pB, static_cast<int>( m_pos.vx - offset.vx - 1 ),
               static_cast<int>( m_pos.vy - offset.vy ),
               static_cast<int>( m_pos.vx - offset.vx + 1 ),
               c.allC() );
    vline( pB, static_cast<int>( m_pos.vx - offset.vx ),
               static_cast<int>( m_pos.vy - offset.vy - 1 ),
               static_cast<int>( m_pos.vy - offset.vy + 1 ),
               c.allC() );
  }
}



/** Sets the color
 */
void Particle::setColor( const Color& rC )
{
  m_grad = Gradient( rC, rC );
}



/** Sets the lifetime
 */
void Particle::lifetime( int ltime )
{
  m_timeleft = ltime;
  m_maxlife = ltime;
}

} // end of namespace
